/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.network.message;

import com.momosoftworks.coldsweat.util.ClientOnlyHelper;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class SyncContainerSlotMessage {
    int slot;
    ItemStack stack;
    int containerId = -1;

    public SyncContainerSlotMessage(int slot, ItemStack stack, int containerId) {
        this.slot = slot;
        this.stack = stack;
        this.containerId = containerId;
    }

    public SyncContainerSlotMessage(int slot, ItemStack stack, AbstractContainerMenu container) {
        this.slot = slot;
        this.stack = stack;
        this.containerId = container.f_38840_;
    }

    public static void encode(SyncContainerSlotMessage msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.slot);
        buffer.writeItemStack(ItemStack.m_41712_((CompoundTag)msg.stack.m_41739_(new CompoundTag())), false);
        buffer.m_130130_(msg.containerId);
    }

    public static SyncContainerSlotMessage decode(FriendlyByteBuf buffer) {
        int slot = buffer.readInt();
        ItemStack stack = buffer.m_130267_();
        int containerId = buffer.m_130242_();
        return new SyncContainerSlotMessage(slot, stack, containerId);
    }

    public static void handle(SyncContainerSlotMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> {
                AbstractContainerMenu container = ClientOnlyHelper.getClientPlayer().f_36096_;
                if (container.f_38840_ == message.containerId && container.m_207775_(message.slot)) {
                    ((Slot)container.f_38839_.get(message.slot)).m_5852_(message.stack);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

